enemySpritePatterns:    ;; from here on, each offset of 32 pixels is a different enemy sprite
explosion_sprite:
    ; LARGE
    db #00,#00,#00,#18,#1c,#0e,#02,#60,#70,#00,#06,#0c,#1c,#19,#01,#00
    db #00,#c0,#c0,#8c,#1c,#38,#20,#0e,#06,#00,#20,#38,#9c,#8c,#80,#00
    ; MEDIUM
    db #00,#00,#00,#00,#00,#0c,#06,#02,#30,#38,#00,#06,#0c,#0c,#00,#00
    db #00,#00,#00,#c0,#80,#98,#30,#20,#00,#1c,#04,#20,#b0,#98,#80,#00
    ; SMALL
    db #00,#00,#00,#00,#00,#00,#00,#04,#02,#00,#0c,#00,#02,#04,#00,#00
    db #00,#00,#00,#00,#00,#00,#80,#90,#20,#00,#18,#00,#20,#90,#80,#00
    ; TINY
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#02,#00,#00,#02,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#20,#00,#00,#20,#80,#00

rat_enemySprite:
    ; sprite 1
    ; LARGE
    db #00,#00,#00,#0f,#10,#20,#41,#00,#19,#37,#0f,#05,#0f,#1e,#18,#00
    db #00,#00,#fc,#02,#7a,#fc,#fc,#7e,#be,#d6,#26,#ac,#28,#40,#00,#00
    ; MEDIUM
    db #00,#00,#00,#03,#0c,#10,#01,#02,#19,#0f,#05,#0f,#1c,#18,#00,#00
    db #00,#00,#00,#c0,#38,#04,#f4,#78,#b8,#78,#78,#58,#50,#80,#00,#00
    ; SMALL:
    db #00,#00,#00,#00,#00,#03,#0c,#00,#03,#00,#0f,#06,#0e,#19,#00,#00
    db #00,#00,#00,#00,#00,#e0,#10,#08,#e8,#f0,#70,#f0,#a0,#00,#00,#00
    ; TINY:
    db #00,#00,#00,#00,#00,#00,#00,#00,#03,#04,#01,#03,#07,#06,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#e0,#10,#f0,#e0,#e0,#80,#00,#00

    ; sprite 2
    ; LARGE:
    db #00,#01,#06,#08,#10,#10,#21,#03,#02,#19,#37,#0f,#05,#0f,#1e,#18
    db #00,#f8,#04,#02,#7a,#fc,#fc,#fe,#7e,#96,#e6,#2c,#a8,#40,#00,#00
    ; MEDIUM:
    db #00,#00,#01,#06,#08,#10,#01,#03,#02,#19,#0f,#05,#0e,#1c,#18,#00
    db #00,#00,#c0,#30,#08,#04,#f4,#f8,#78,#b8,#78,#58,#50,#80,#00,#00
    ; SMALL:
    db #00,#00,#00,#00,#00,#00,#03,#04,#0b,#00,#0f,#06,#0e,#19,#00,#00
    db #00,#00,#00,#00,#00,#c0,#30,#08,#e8,#f0,#70,#f0,#a0,#00,#00,#00
    ; TINY:
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#05,#03,#07,#06,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#e0,#10,#f0,#e0,#e0,#80,#00,#00

blob_enemySprite:
    ; sprite1
    ; LARGE
    db #00,#00,#00,#0b,#07,#07,#0e,#09,#0c,#0f,#1f,#1e,#3d,#61,#03,#00
    db #00,#00,#00,#80,#e8,#f0,#70,#98,#38,#f0,#f8,#fc,#fc,#8e,#02,#00
    ; MEDIUM
    db #00,#00,#00,#00,#00,#01,#0b,#06,#05,#06,#07,#0f,#1e,#31,#03,#00
    db #00,#00,#00,#00,#00,#c0,#e0,#68,#b0,#70,#e0,#e0,#f0,#f8,#0c,#00
    ; SMALL
    db #00,#00,#00,#00,#00,#00,#00,#05,#03,#02,#05,#06,#07,#0f,#19,#00
    db #00,#00,#00,#00,#00,#00,#00,#c0,#e0,#e0,#60,#e0,#e0,#f0,#98,#00
    ; TINY
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#03,#02,#03,#07,#0d,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#c0,#c0,#e0,#b0,#00

    ; sprite4
    ; LARGE
    db #00,#00,#00,#00,#0b,#07,#07,#0e,#09,#0c,#1f,#3e,#7d,#c1,#03,#00
    db #00,#00,#00,#00,#c0,#e8,#f0,#70,#98,#30,#f8,#fc,#fe,#87,#00,#00
    ; MEDIUM
    db #00,#00,#00,#00,#00,#00,#01,#0b,#06,#05,#06,#0f,#3e,#61,#03,#00
    db #00,#00,#00,#00,#00,#00,#c0,#e0,#68,#b0,#70,#e0,#f0,#fc,#00,#00
    ; SMALL
    db #00,#00,#00,#00,#00,#00,#00,#00,#05,#03,#02,#05,#06,#0f,#18,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#c0,#e0,#e0,#60,#e0,#f0,#d8,#00
    ; TINY
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#05,#03,#02,#07,#0d,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#c0,#e0,#b0,#00


skeleton_forward_enemySprite:
    ; sprite1
      ; LARGE:
      db #07,#0f,#09,#09,#0e,#07,#15,#2a,#4b,#81,#87,#9a,#20,#98,#0c,#38
      db #c0,#e0,#20,#20,#e0,#c0,#50,#a8,#a4,#02,#c2,#b2,#08,#32,#60,#38
      ; MEDIUM:
      db #00,#00,#07,#09,#09,#0e,#07,#15,#28,#4b,#41,#47,#0a,#50,#08,#38
      db #00,#00,#c0,#20,#20,#e0,#c0,#50,#28,#a4,#04,#c4,#a0,#14,#20,#38
      ; SMALL:
      db #00,#00,#00,#00,#00,#03,#05,#05,#07,#12,#20,#21,#27,#08,#04,#0c
      db #00,#00,#00,#00,#00,#80,#40,#40,#c0,#90,#08,#08,#c8,#20,#40,#60
      ; TINY:
      db #00,#00,#00,#00,#00,#00,#00,#00,#03,#05,#03,#0a,#10,#13,#02,#06
      db #00,#00,#00,#00,#00,#00,#00,#00,#80,#40,#80,#a0,#10,#90,#80,#c0

    ; sprite2
      ; LARGE:
      db #00,#07,#0f,#09,#09,#0e,#07,#15,#6a,#8b,#81,#9f,#22,#98,#0c,#38
      db #00,#c0,#e0,#20,#20,#e0,#c0,#50,#ac,#a2,#02,#f2,#88,#32,#60,#38
      ; MEDIUM:
      db #00,#00,#00,#07,#09,#09,#0e,#07,#15,#28,#4b,#41,#4f,#12,#48,#38
      db #00,#00,#00,#c0,#20,#20,#e0,#c0,#50,#28,#a4,#04,#e4,#90,#24,#38
      ; SMALL:
      db #00,#00,#00,#00,#00,#00,#03,#05,#05,#07,#12,#20,#21,#2f,#04,#0c
      db #00,#00,#00,#00,#00,#00,#80,#40,#40,#c0,#90,#08,#08,#e8,#40,#60
      ; TINY:
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#05,#0b,#12,#11,#02,#06
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#40,#a0,#90,#10,#80,#c0

    ; sprite3
      ; LARGE:
      db #00,#00,#07,#0f,#09,#09,#06,#77,#85,#8a,#81,#1f,#a2,#18,#0c,#38
      db #00,#00,#c0,#e0,#20,#20,#c0,#dc,#42,#a2,#02,#f0,#8a,#30,#60,#38
      ; MEDIUM:
      db #00,#00,#00,#00,#07,#09,#09,#0e,#37,#45,#48,#41,#0f,#52,#08,#38
      db #00,#00,#00,#00,#c0,#20,#20,#e0,#d8,#44,#24,#04,#e0,#94,#20,#38
      ; SMALL:
      db #00,#00,#00,#00,#00,#00,#03,#05,#05,#17,#22,#20,#21,#0f,#04,#0c
      db #00,#00,#00,#00,#00,#00,#80,#40,#40,#d0,#88,#08,#08,#e0,#40,#60
      ; TINY:
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#0d,#13,#12,#01,#02,#06
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#60,#90,#90,#00,#80,#c0


knight_enemySprite:
      ; sprite1
      ; LARGE:
      db #00,#0f,#10,#0f,#1a,#1a,#1a,#2f,#70,#6e,#66,#46,#0b,#1d,#0c,#3c
      db #00,#e0,#10,#e0,#b0,#b0,#b0,#00,#fc,#fc,#fc,#fc,#78,#30,#40,#78
      ; MEDIUM:
      db #00,#00,#00,#07,#08,#07,#0a,#0a,#17,#38,#36,#26,#0b,#0d,#04,#1c
      db #00,#00,#00,#c0,#20,#c0,#a0,#a0,#00,#f8,#f8,#f8,#70,#20,#40,#70
      ; SMALL:
      db #00,#00,#00,#00,#00,#00,#07,#0f,#0a,#0a,#07,#18,#17,#13,#02,#06
      db #00,#00,#00,#00,#00,#00,#c0,#e0,#a0,#a0,#c0,#70,#70,#70,#a0,#c0
      ; TINY:
      db #00,#00,#00,#00,#00,#00,#00,#00,#03,#07,#05,#07,#08,#0b,#02,#06
      db #00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#40,#c0,#e0,#e0,#e0,#c0

      ; sprite2
      ; LARGE:
      db #00,#00,#0f,#10,#0f,#1a,#1a,#1a,#2f,#70,#6e,#66,#4a,#1d,#0c,#3c
      db #00,#00,#e0,#10,#e0,#b0,#b0,#b0,#00,#fc,#fc,#fc,#fc,#78,#30,#48
      ; MEDIUM:
      db #00,#00,#00,#00,#07,#08,#07,#0a,#0a,#17,#38,#36,#2a,#0d,#04,#1c
      db #00,#00,#00,#00,#c0,#20,#c0,#a0,#a0,#00,#f8,#f8,#f8,#70,#20,#50
      ; SMALL:
      db #00,#00,#00,#00,#00,#00,#00,#07,#0f,#0a,#0a,#07,#18,#13,#12,#06
      db #00,#00,#00,#00,#00,#00,#00,#c0,#e0,#a0,#a0,#c0,#70,#70,#70,#a0
      ; TINY:
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#07,#05,#03,#08,#0a,#06
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#40,#e0,#e0,#e0,#c0

      ; sprite3
      ; LARGE:
      db #00,#00,#0f,#10,#0f,#1a,#1a,#1a,#2f,#70,#6e,#66,#4a,#1c,#0c,#3c
      db #00,#00,#e0,#10,#e0,#b0,#b0,#b0,#e0,#00,#fc,#fc,#fc,#fc,#78,#30
      ; MEDIUM:
      db #00,#00,#00,#00,#07,#08,#07,#0a,#0a,#17,#38,#36,#2a,#0c,#04,#1c
      db #00,#00,#00,#00,#c0,#20,#c0,#a0,#a0,#00,#00,#f8,#f8,#f8,#70,#20
      ; SMALL:
      db #00,#00,#00,#00,#00,#00,#00,#07,#0f,#0a,#0a,#07,#18,#13,#12,#06
      db #00,#00,#00,#00,#00,#00,#00,#c0,#e0,#a0,#a0,#80,#e0,#e0,#e0,#40
      ; TTINY:
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#07,#05,#03,#08,#0a,#06
      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#40,#e0,#e0,#e0,#c0

snake_enemySprite:
    ; sprite1
    ; LARGE:
    db #00,#00,#00,#07,#0b,#17,#3f,#3d,#33,#03,#07,#07,#07,#07,#07,#03
    db #00,#00,#00,#00,#80,#80,#82,#86,#8c,#98,#9c,#0c,#38,#f8,#f0,#80
    ; MEDIUM:
    db #00,#00,#00,#00,#00,#03,#07,#0b,#1f,#19,#03,#03,#03,#03,#03,#01
    db #00,#00,#00,#00,#00,#00,#80,#80,#88,#90,#90,#18,#18,#38,#f0,#c0
    ; SMALL:
    db #00,#00,#00,#00,#00,#00,#00,#03,#05,#0f,#0d,#01,#03,#03,#03,#01
    db #00,#00,#00,#00,#00,#00,#00,#00,#80,#80,#90,#a0,#20,#20,#e0,#c0
    ; TINY:
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#05,#07,#01,#01,#01,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#20,#20,#e0,#c0

    ; sprite2
    ; LARGE:
    db #00,#00,#00,#00,#0e,#17,#2f,#7d,#7b,#63,#03,#07,#07,#07,#07,#03
    db #00,#00,#00,#00,#00,#00,#90,#98,#8c,#8c,#9c,#18,#38,#f8,#f0,#80
    ; MEDIUM:
    db #00,#00,#00,#00,#00,#00,#06,#0f,#17,#3f,#33,#03,#03,#03,#03,#01
    db #00,#00,#00,#00,#00,#00,#00,#00,#10,#08,#08,#18,#18,#38,#f0,#c0
    ; SMALL:
    db #00,#00,#00,#00,#00,#00,#00,#06,#0b,#1f,#1b,#03,#03,#03,#03,#01
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#40,#20,#20,#20,#e0,#c0
    ; TINY:
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#05,#07,#01,#01,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#20,#20,#e0,#c0


medusa_enemySprite:
    ; TORSO 1:
    ; LARGE:
  db #01, #06, #19, #27, #08, #13, #05, #09, #00, #00, #07, #0f, #1b, #11, #31, #21
  db #e0, #18, #e6, #f9, #c4, #f2, #28, #24, #c0, #00, #38, #fc, #f6, #62, #f3, #f1
    ; MEDIUM
  db #00, #00, #00, #01, #06, #0b, #04, #0b, #05, #00, #00, #07, #0f, #09, #11, #11
  db #00, #00, #00, #e0, #18, #f4, #c8, #f4, #28, #c0, #00, #38, #fc, #e4, #e2, #e2
    ; SMALL
  db #00, #00, #00, #00, #00, #00, #02, #01, #04, #01, #04, #00, #03, #05, #05, #09
  db #00, #00, #00, #00, #00, #00, #20, #c0, #90, #c0, #90, #00, #e0, #d0, #d0, #c8
    ; TINY:
  db #00, #00, #00, #00, #00, #00, #00, #00, #02, #00, #05, #01, #00, #03, #05, #09
  db #00, #00, #00, #00, #00, #00, #00, #00, #40, #00, #a0, #80, #00, #c0, #a0, #90

    ; TAIL 1:
    ; LARGE:
  db #00, #03, #03, #03, #03, #43, #61, #61, #71, #7b, #3f, #3f, #1f, #00, #0a, #00
  db #00, #70, #78, #80, #b8, #bc, #9c, #80, #bc, #bc, #9c, #60, #7c, #b8, #c0, #00
    ; MEDIUM:
  db #00, #03, #03, #03, #01, #21, #21, #33, #3f, #3f, #1f, #00, #05, #00, #00, #00
  db #00, #60, #70, #80, #b8, #b8, #80, #b8, #b8, #80, #38, #50, #60, #00, #00, #00
    ; SMALL:
  db #00, #01, #01, #09, #09, #0f, #0f, #04, #02, #00, #00, #00, #00, #00, #00, #00
  db #00, #60, #00, #60, #00, #60, #00, #60, #c0, #00, #00, #00, #00, #00, #00, #00
    ; TINY:
  db #00, #01, #05, #07, #07, #03, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00
  db #00, #80, #80, #80, #80, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00

    ; TORSO 2:
    ; LARGE:
  db #00, #01, #26, #19, #07, #18, #03, #0d, #01, #00, #07, #0f, #1b, #11, #19, #09
  db #00, #e0, #19, #e6, #f8, #c6, #f0, #2c, #e0, #c0, #38, #fc, #f6, #62, #f6, #f4
    ; MEDIUM:
  db #00, #00, #00, #00, #09, #06, #0b, #04, #03, #05, #00, #07, #0f, #09, #09, #05
  db #00, #00, #00, #00, #e4, #18, #f4, #c8, #f0, #28, #c0, #38, #fc, #e4, #e4, #e8
    ; SMALL:
  db #00, #00, #00, #00, #00, #00, #00, #02, #01, #04, #01, #04, #03, #05, #05, #05
  db #00, #00, #00, #00, #00, #00, #00, #20, #c0, #90, #c0, #90, #60, #d0, #d0, #d0
    ; TINY:
  db #00, #00, #00, #00, #00, #00, #00, #00, #00, #02, #00, #05, #01, #03, #05, #05
  db #00, #00, #00, #00, #00, #00, #00, #00, #00, #40, #00, #a0, #80, #c0, #a0, #a0
    ; TAIL 2:
    ; LARGE:
  db #00, #03, #03, #03, #01, #11, #31, #31, #71, #7b, #3f, #3f, #1f, #00, #0a, #00
  db #00, #70, #78, #80, #bc, #de, #de, #c0, #de, #be, #9c, #60, #7c, #b8, #c0, #00
    ; MEDIUM:
  db #00, #03, #03, #03, #01, #09, #19, #1b, #3f, #3f, #1f, #00, #05, #00, #00, #00
  db #00, #60, #70, #80, #b8, #b8, #80, #b8, #b8, #80, #38, #50, #60, #00, #00, #00
    ; SMALL:
  db #00, #01, #01, #05, #09, #0f, #0f, #04, #02, #00, #00, #00, #00, #00, #00, #00
  db #00, #60, #00, #60, #00, #60, #00, #60, #c0, #00, #00, #00, #00, #00, #00, #00
    ; TINY:
  db #00, #01, #05, #07, #07, #03, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00
  db #00, #80, #80, #80, #80, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00


ker_enemySprite:
    ; HAIR 1:
    ; LARGE:
  db #00, #01, #13, #1b, #0f, #77, #3f, #1f, #11, #00, #06, #00, #01, #01, #00, #00
  db #00, #20, #60, #6c, #78, #f6, #fc, #f8, #88, #00, #60, #00, #80, #80, #00, #00
    ; MEDIUM
  db #00, #00, #00, #00, #01, #0d, #07, #3f, #1f, #1f, #11, #00, #06, #00, #01, #01
  db #00, #00, #00, #00, #20, #68, #f0, #fc, #f8, #f8, #88, #00, #60, #00, #80, #80
    ; SMALL
  db #04, #02, #1b, #0f, #07, #01, #00, #02, #00, #01, #00, #00, #00, #00, #00, #00
  db #a0, #c0, #d8, #f0, #e0, #80, #00, #40, #00, #80, #00, #00, #00, #00, #00, #00
    ; TINY:
  db #00, #00, #00, #00, #05, #03, #03, #01, #00, #00, #00, #00, #00, #00, #00, #00
  db #00, #00, #00, #00, #a0, #c0, #c0, #80, #00, #00, #00, #00, #00, #00, #00, #00

    ; BODY 1:
    ; LARGE:
  db #00, #0e, #71, #f7, #c2, #9c, #bd, #22, #03, #21, #06, #06, #02, #0c, #14, #00
  db #00, #70, #8e, #ef, #43, #39, #bd, #44, #c0, #84, #60, #60, #40, #30, #28, #00
    ; MEDIUM:
  db #00, #00, #00, #0e, #31, #77, #42, #5c, #11, #02, #11, #06, #02, #04, #0c, #00
  db #00, #00, #00, #70, #8c, #ee, #42, #3a, #88, #40, #88, #60, #40, #20, #30, #00
    ; SMALL:
  db #00, #00, #00, #00, #00, #00, #16, #39, #23, #04, #09, #10, #03, #02, #04, #00
  db #00, #00, #00, #00, #00, #00, #68, #9c, #c4, #20, #90, #08, #c0, #40, #20, #00
    ; TINY:
  db #00, #00, #00, #00, #00, #00, #00, #0c, #01, #0d, #08, #01, #01, #02, #02, #00
  db #00, #00, #00, #00, #00, #00, #00, #30, #80, #b0, #10, #80, #80, #40, #40, #00

    ; HAIR 2:
    ; LARGE:
  db #00, #01, #13, #1b, #0f, #77, #3f, #1f, #11, #00, #06, #00, #00, #00, #00, #00
  db #00, #20, #60, #6c, #78, #f6, #fc, #f8, #88, #00, #60, #00, #00, #00, #00, #00
    ; MEDIUM:
  db #00, #00, #00, #00, #01, #0d, #07, #3f, #1f, #1f, #11, #00, #06, #00, #00, #00
  db #00, #00, #00, #00, #20, #68, #f0, #fc, #f8, #f8, #88, #00, #60, #00, #00, #00
    ; SMALL:
  db #04, #02, #1b, #0f, #07, #01, #00, #02, #00, #00, #00, #00, #00, #00, #00, #00
  db #a0, #c0, #d8, #f0, #e0, #80, #00, #40, #00, #00, #00, #00, #00, #00, #00, #00
    ; TINY:
  db #00, #00, #00, #00, #05, #03, #03, #01, #00, #00, #00, #00, #00, #00, #00, #00
  db #00, #00, #00, #00, #a0, #c0, #c0, #80, #00, #00, #00, #00, #00, #00, #00, #00

    ; BODY 2:
    ; LARGE:
  db #00, #6e, #f1, #d7, #83, #8d, #1e, #33, #23, #01, #26, #06, #02, #0c, #14, #00
  db #00, #76, #8f, #eb, #c1, #b1, #78, #cc, #c4, #80, #64, #60, #40, #30, #28, #00
    ; MEDIUM:
  db #00, #00, #00, #2e, #71, #57, #43, #0d, #1a, #13, #01, #16, #02, #04, #0c, #00
  db #00, #00, #00, #74, #8e, #ea, #c2, #b0, #58, #c8, #80, #68, #40, #20, #30, #00
    ; SMALL:
  db #00, #00, #00, #00, #00, #00, #36, #39, #03, #0d, #12, #11, #03, #02, #04, #00
  db #00, #00, #00, #00, #00, #00, #6c, #9c, #c0, #b0, #48, #88, #c0, #40, #20, #00
    ; TINY:
  db #00, #00, #00, #00, #00, #00, #00, #0c, #09, #05, #08, #09, #01, #02, #02, #00
  db #00, #00, #00, #00, #00, #00, #00, #30, #90, #a0, #10, #90, #80, #40, #40, #00

switchRightSprite:
    ; LARGE
    db #00,#00,#00,#00,#00,#00,#00,#03,#04,#0b,#16,#2e,#2f,#2f,#3f,#00
    db #00,#00,#00,#06,#0e,#1c,#38,#d0,#20,#d0,#68,#74,#f4,#f4,#fc,#00
    ; MEDIUM
    db #00,#00,#00,#00,#00,#00,#00,#00,#03,#04,#0b,#16,#16,#17,#1f,#00
    db #00,#00,#00,#00,#00,#0c,#1c,#38,#d0,#20,#d0,#68,#68,#e8,#f8,#00
    ; SMALL
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#06,#0e,#0f,#0f,#00
    db #00,#00,#00,#00,#00,#00,#00,#18,#30,#60,#c0,#60,#70,#f0,#f0,#00
    ; TINY
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#06,#07,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#10,#20,#40,#c0,#60,#e0,#00
switchLeftSprite:
    ; LARGE
    db #00,#00,#00,#60,#70,#38,#1c,#0b,#04,#0b,#16,#2e,#2f,#2f,#3f,#00
    db #00,#00,#00,#00,#00,#00,#00,#c0,#20,#d0,#68,#74,#f4,#f4,#fc,#00
    ; MEDIUM
    db #00,#00,#00,#00,#00,#30,#38,#1c,#0b,#04,#0b,#16,#16,#17,#1f,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#c0,#20,#d0,#68,#68,#e8,#f8,#00
    ; SMALL
    db #00,#00,#00,#00,#00,#00,#00,#18,#0c,#06,#03,#06,#0e,#0f,#0f,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#c0,#60,#70,#f0,#f0,#00
    ; TINY
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#08,#04,#02,#03,#06,#07,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#c0,#60,#e0,#00

; Version of the switches that is pressed or not, rather than switching left/right:
;switchRightSprite:
;    ; sprite1
;    db #00,#00,#00,#07,#07,#00,#01,#01,#01,#0f,#10,#2f,#2f,#2f,#3f,#00
;    db #00,#00,#00,#e0,#e0,#00,#80,#80,#80,#f0,#08,#f4,#f4,#f4,#fc,#00
;    ; sprite2
;    db #00,#00,#00,#00,#00,#07,#07,#00,#01,#01,#07,#08,#17,#17,#1f,#00
;    db #00,#00,#00,#00,#00,#e0,#e0,#00,#80,#80,#e0,#10,#e8,#e8,#f8,#00
;    ; sprite3
;    db #00,#00,#00,#00,#00,#00,#00,#03,#00,#01,#01,#07,#08,#0b,#0f,#00
;    db #00,#00,#00,#00,#00,#00,#00,#c0,#00,#80,#80,#e0,#10,#d0,#f0,#00
;    ; sprite4
;    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#01,#01,#03,#05,#07,#00
;    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#00,#00,#80,#40,#c0,#00
;
;switchLeftSprite:
;    ; sprite1
;    db #00,#00,#00,#00,#00,#00,#07,#07,#01,#0f,#10,#2f,#2f,#2f,#3f,#00
;    db #00,#00,#00,#00,#00,#00,#e0,#e0,#80,#f0,#08,#f4,#f4,#f4,#fc,#00
;    ; sprite2
;    db #00,#00,#00,#00,#00,#00,#00,#07,#07,#01,#07,#08,#17,#17,#1f,#00
;    db #00,#00,#00,#00,#00,#00,#00,#e0,#e0,#80,#e0,#10,#e8,#e8,#f8,#00
;    ; sprite3
;    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#00,#07,#08,#0b,#0f,#00
;    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#c0,#00,#e0,#10,#d0,#f0,#00
;    ; sprite4
;    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#03,#03,#05,#07,#00
;    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#80,#40,#c0,#00



enemyBulletSprite:
    ; LARGE
    db #00,#00,#00,#00,#00,#00,#00,#00,#01,#02,#03,#03,#01,#00,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#c0,#c0,#80,#00,#00,#00
    ; MEDIUM
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#01,#03,#03,#01,#00,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#c0,#c0,#80,#00,#00,#00
    ; SMALL
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#01,#01,#00,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#80,#80,#00,#00,#00
    ; TINY
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#01,#00,#00,#00
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00


; Unused enemy sprites:
; 
;fireball_enemySprite:
;    ; LARGE
;    db #00,#00,#00,#02,#0f,#07,#1e,#0c,#1c,#0e,#1f,#0f,#05,#00,#00,#00
;    db #00,#00,#00,#60,#e0,#f8,#70,#30,#38,#60,#f0,#e0,#a0,#00,#00,#00
;    ; MEDIUM
;    db #00,#00,#00,#00,#00,#02,#07,#0e,#0c,#04,#0e,#07,#02,#00,#00,#00
;    db #00,#00,#00,#00,#00,#c0,#e0,#70,#20,#30,#60,#e0,#c0,#00,#00,#00
;    ; SMALL
;    db #00,#00,#00,#00,#00,#00,#01,#01,#07,#06,#03,#03,#01,#00,#00,#00
;    db #00,#00,#00,#00,#00,#00,#40,#e0,#60,#30,#70,#e0,#40,#00,#00,#00
;    ; TINY
;    db #00,#00,#00,#00,#00,#00,#00,#00,#03,#02,#06,#03,#01,#00,#00,#00
;    db #00,#00,#00,#00,#00,#00,#00,#80,#c0,#40,#60,#c0,#00,#00,#00,#00
;
;python_enemySprite:
;    ; Sprite 1 (left)
;    ; LARGE: 
;      db #00,#00,#01,#03,#0e,#19,#37,#6f,#5f,#d1,#c0,#c0,#80,#00,#00,#00
;      db #00,#40,#82,#1a,#8f,#c7,#c1,#ea,#db,#b5,#69,#5d,#4e,#11,#1f,#04
;    ; MEDIUM: 
;      db #00,#00,#00,#00,#03,#06,#0d,#1b,#17,#34,#30,#20,#20,#00,#00,#00
;      db #00,#00,#20,#c2,#9a,#4f,#c3,#e0,#eb,#d5,#55,#35,#2a,#2e,#19,#07
;    ; SMALL: 
;      db #00,#00,#00,#00,#00,#00,#00,#00,#01,#02,#02,#02,#00,#00,#00,#00
;      db #00,#00,#00,#00,#00,#10,#60,#81,#67,#fa,#35,#0d,#0e,#0e,#07,#03
;    ; TINY: 
;      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
;      db #00,#00,#00,#00,#00,#00,#00,#08,#10,#3a,#79,#4d,#02,#06,#07,#03
;    ; Sprite 1 (right)
;    ; LARGE: (
;      db #00,#00,#08,#0b,#1e,#fd,#f2,#4b,#fb,#f0,#50,#f0,#e8,#1e,#61,#de
;      db #00,#00,#00,#00,#00,#80,#c0,#60,#a0,#b2,#32,#36,#0c,#3c,#f8,#70
;    ; MEDIUM:
;      db #00,#00,#00,#10,#16,#fc,#f3,#c5,#f6,#e2,#e0,#e0,#c0,#3f,#c7,#b9
;      db #00,#00,#00,#00,#00,#00,#00,#80,#80,#c0,#c8,#18,#70,#f0,#e0,#80
;    ; SMALL: 
;      db #00,#00,#00,#00,#00,#20,#18,#24,#fa,#d5,#e1,#e1,#c0,#c0,#3f,#ff
;      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#40,#c0,#80,#00
;    ; TINY: 
;      db #00,#00,#00,#00,#00,#00,#00,#20,#10,#28,#dc,#c4,#80,#84,#78,#e0
;      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
;
;    ; Sprite 2: (left)
;    ; LARGE: 
;      db #00,#00,#01,#0f,#18,#37,#6f,#df,#c1,#c0,#80,#00,#00,#00,#00,#00
;      db #10,#60,#c0,#02,#da,#cf,#e7,#e9,#da,#b3,#69,#5d,#4d,#10,#1f,#04
;    ; MEDIUM: 
;      db #00,#00,#00,#00,#03,#06,#0d,#1b,#10,#30,#20,#20,#00,#00,#00,#00
;      db #00,#00,#38,#e0,#82,#5a,#ef,#f3,#e8,#5b,#15,#35,#29,#2e,#19,#07
;    ; SMALL: 
;      db #00,#00,#00,#00,#00,#00,#00,#00,#01,#02,#00,#00,#00,#00,#00,#00
;      db #00,#00,#00,#00,#00,#18,#60,#90,#79,#17,#12,#0d,#0d,#0e,#06,#03
;    ; TINY: 
;      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
;      db #00,#00,#00,#00,#00,#00,#00,#0c,#18,#38,#5a,#0d,#01,#06,#06,#03
;    ; Sprite 2: (right)
;    ; LARGE: 
;      db #10,#0c,#06,#08,#0b,#1e,#fc,#f3,#48,#f8,#f0,#50,#f0,#ee,#01,#de
;      db #00,#00,#00,#00,#00,#80,#c0,#60,#60,#68,#24,#04,#0c,#3c,#f8,#70
;    ; MEDIUM: 
;      db #00,#00,#70,#08,#10,#16,#fd,#f1,#c0,#f0,#e0,#e0,#e0,#df,#07,#b9
;      db #00,#00,#00,#00,#00,#00,#00,#80,#80,#c0,#48,#18,#70,#f0,#e0,#80
;    ; SMALL: 
;      db #00,#00,#00,#00,#00,#60,#18,#04,#22,#f9,#d0,#e0,#e0,#c0,#df,#3f
;      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#40,#c0,#80,#00
;    ; TINY: 
;      db #00,#00,#00,#00,#00,#00,#00,#60,#30,#18,#24,#c0,#c0,#84,#b8,#60
;      db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
;
;skeleton_left_enemySprite:
;      ; sprite1
;      db #01,#01,#00,#03,#06,#0a,#31,#30,#08,#04,#22,#3b,#26,#44,#0f,#00
;      db #fc,#fe,#e4,#64,#be,#4a,#20,#90,#4c,#36,#1a,#08,#00,#00,#80,#00
;      ; sprite6
;      db #01,#01,#00,#03,#06,#0a,#31,#38,#16,#09,#04,#0c,#18,#30,#7c,#00
;      db #fc,#fe,#e4,#64,#be,#4a,#20,#90,#4c,#36,#9a,#c8,#c0,#f8,#00,#00
;      ; sprite7
;      db #00,#01,#01,#00,#03,#06,#0a,#32,#31,#0c,#02,#0c,#18,#31,#3d,#00
;      db #00,#fc,#fe,#e4,#64,#be,#8a,#40,#30,#cc,#76,#1a,#c8,#80,#e0,#00


item_sprite_colors: ; sprite/4 indexes this table (only used for arrows, chests, potions, hearts and keys)
    db 7,9  ;; ice arrows / arrows
    db 10,7,5,10    ;; chests / potions / hearts / keys


knight_sprites:
    ; walk sprite1
    db #0f,#1f,#1f,#1f,#1f,#1f,#07,#00,#1b,#3b,#37,#27,#00,#07,#06,#00
    db #f0,#f8,#f8,#f8,#f8,#f8,#e0,#00,#d8,#dc,#ec,#04,#e0,#60,#40,#00
    ; walk sprite2
    db #00,#0f,#1f,#1f,#1f,#1f,#1f,#04,#1b,#3b,#37,#20,#07,#06,#02,#00
    db #00,#f0,#f8,#f8,#f8,#f8,#f8,#20,#d8,#dc,#ec,#e4,#00,#e0,#60,#00
    ; sword swing sprite
    db #00,#0f,#1f,#1f,#1f,#1f,#1f,#04,#1b,#3b,#37,#27,#00,#07,#06,#00
    db #00,#f0,#f8,#f8,#f8,#f8,#f0,#20,#d0,#e0,#e0,#00,#e0,#60,#40,#00


knight_sprites_outline:
    ; walk sprite1
    db #0f,#10,#20,#23,#20,#20,#20,#18,#1f,#24,#44,#48,#58,#2f,#08,#09
    db #f0,#08,#04,#c4,#04,#04,#04,#18,#f8,#24,#22,#12,#fa,#14,#90,#a0
    ; walk sprite2
    db #00,#0f,#10,#20,#23,#20,#20,#20,#1b,#24,#44,#48,#5f,#28,#09,#05
    db #00,#f0,#08,#04,#c4,#04,#04,#04,#d8,#24,#22,#12,#1a,#f4,#10,#90
    ; sword swing sprite
    db #00,#0f,#10,#20,#23,#20,#20,#20,#1b,#24,#44,#48,#58,#2f,#08,#09
    db #00,#f0,#08,#04,#c4,#04,#04,#08,#d8,#28,#10,#10,#f0,#10,#90,#a0


sword_sprite:
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    db #00,#80,#c0,#c0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

goldsword_sprite:
    db #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    db #80,#c0,#c0,#c0,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00

